IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_COLOCAR_NA_RC_PGTO_PDV_PENDENTE]') AND TYPE IN (N'P', N'PC'))
DROP PROCEDURE [DBO].[P_COLOCAR_NA_RC_PGTO_PDV_PENDENTE]
GO

--VERSAO 2939
--EXEC P_COLOCAR_NA_RC_PGTO_PDV_PENDENTE
CREATE PROCEDURE [DBO].[P_COLOCAR_NA_RC_PGTO_PDV_PENDENTE] WITH ENCRYPTION AS
DECLARE @CD_EMP INT
DECLARE @CD_CTR_PGTO INT
DECLARE @DT_PGTO DATETIME
DECLARE @CD_USU INT

DECLARE PENDENTE CURSOR FOR  

SELECT 
	1 AS CD_EMP, A.CD_CTR_PGTO, A.DT_PGTO, A.CD_USU
FROM RC_PGTO_PDV A 
	LEFT JOIN PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV B ON
	A.CD_CTR_PGTO = B.CD_CTR_PGTO
	LEFT JOIN PDV_CUPOM_NAO_FISCAL C ON 
	B.CD_EMP = C.CD_EMP AND
	B.CD_FILIAL = C.CD_FILIAL AND
	B.CD_CTR = C.CD_CTR 

	LEFT JOIN RC_PGTO_PDV_PENDENTE BB ON
	BB.CD_CTR_PGTO=A.CD_CTR_PGTO AND
	BB.DT_PGTO=A.DT_PGTO AND
	BB.CD_USU=A.CD_USU

WHERE  B.CD_CTR_PGTO IS NULL
AND C.ST_CUPOM = 0
AND BB.CD_CTR_PGTO IS NULL

OPEN PENDENTE   
FETCH NEXT FROM PENDENTE INTO @CD_EMP,@CD_CTR_PGTO,@DT_PGTO,@CD_USU

WHILE @@FETCH_STATUS = 0   
BEGIN   
	------------------------------------------------------------------------------------------------------------------------
	-- GRAVANDO A PONTUAÇÃO DE VENDAS
	------------------------------------------------------------------------------------------------------------------------
	INSERT INTO RC_PGTO_PDV_PENDENTE (CD_EMP,CD_CTR_PGTO,DT_PGTO,CD_USU) VALUES(@CD_EMP,@CD_CTR_PGTO,@DT_PGTO,@CD_USU)


	FETCH NEXT FROM PENDENTE INTO @CD_EMP,@CD_CTR_PGTO,@DT_PGTO,@CD_USU

END   

CLOSE PENDENTE   
DEALLOCATE PENDENTE

GO


